<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('father_name')->nullable()->after('name');
            $table->text('address')->nullable()->after('father_name');
            $table->string('aadhar_no')->nullable()->after('address');
            $table->string('pan_no')->nullable()->after('aadhar_no');
            $table->string('occupation')->nullable()->after('pan_no');
            $table->string('sex', 10)->nullable()->after('occupation');
            $table->date('dob')->nullable()->after('sex');
            $table->string('mobile')->nullable()->after('email');
            $table->string('whatsapp_no')->nullable()->after('mobile');

            // Membership-related fields
            $table->string('member_level')->nullable()->after('whatsapp_no');
            $table->string('primary_city')->nullable()->after('member_level');
            $table->string('member_code')->nullable()->after('primary_city');
            $table->string('member_cadre')->nullable()->after('member_code');
            $table->string('vg_group_code')->nullable()->after('member_cadre');
            $table->string('vg_group_name')->nullable()->after('vg_group_code');
            $table->string('federation_code')->nullable()->after('vg_group_name');
            $table->string('federation_name')->nullable()->after('federation_code');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'father_name',
                'address',
                'aadhar_no',
                'pan_no',
                'occupation',
                'sex',
                'dob',
                'mobile',
                'whatsapp_no',
                'member_level',
                'primary_city',
                'member_code',
                'member_cadre',
                'vg_group_code',
                'vg_group_name',
                'federation_code',
                'federation_name',
            ]);
        });
    }
};
