<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
    */
    public function up(): void
    {
        Schema::create('receipts', function (Blueprint $table) {
            $table->id();
            $table->string('customer_id')->unique();
            $table->date('receipt_date')->nullable();
            $table->decimal('invested_amount', 10, 2)->nullable();
            $table->string('company_name')->nullable();
            $table->string('receipt_customer_name')->nullable();
            $table->string('relationship')->nullable();
            $table->string('receipt_image')->nullable(); // store file path
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receipts');
    }
};
