<?php

namespace App\Filament\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use App\Models\Receipt;
use App\Models\Settlement;
use Illuminate\Support\Facades\Auth;
use NumberFormatter;

class ReceiptStats extends BaseWidget
{
    protected function getStats(): array
    {
        $userId = Auth::id();

        $noOfReceipts = Receipt::where('user_id', $userId)->count();

        $totalAmount = Receipt::where('user_id', $userId)->sum('invested_amount');

        $settlementAmount = Settlement::where('user_id', $userId)->sum('settlement_amount');

        return [
            Stat::make('No. of Receipts', number_format($noOfReceipts))
                ->icon('heroicon-o-document-text')
                ->color('primary'),

            Stat::make('Total Amount', '₹' . number_format($totalAmount))
                ->icon('heroicon-o-currency-rupee')
                ->formatStateUsing(function ($state) {
                        if ($state === null) return '-';
                        $formatter = new NumberFormatter('en_IN', NumberFormatter::DECIMAL);
                        return '₹ ' . $formatter->format($state);
                    })
                ->color('success'),

            Stat::make('Settlement Amount', '₹' . number_format($settlementAmount))
                ->icon('heroicon-o-hand-thumb-up')
                ->formatStateUsing(function ($state) {
                        if ($state === null) return '-';
                        $formatter = new NumberFormatter('en_IN', NumberFormatter::DECIMAL);
                        return '₹ ' . $formatter->format($state);
                    })
                ->color('warning'),
        ];
    }
}
