<?php

namespace App\Filament\Resources\Users\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class UserForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->required(),
                TextInput::make('father_name')
                    ->default(null),
                Select::make('sex')
                    ->label('Gender')
                    ->required()
                    ->options([
                        'Male' => 'Male',
                        'Female' => 'Female',
                    ]),
                DatePicker::make('dob')
                    ->label('Date of Birth'),
                Textarea::make('address')
                    ->default(null)
                    ->columnSpanFull(),
                TextInput::make('aadhar_no')
                    ->default(null),
                TextInput::make('pan_no')
                    ->default(null),
                TextInput::make('occupation')
                    ->default(null),
                TextInput::make('email')
                    ->label('Email Id')
                    ->email()
                    ->required(),
                TextInput::make('mobile')
                    ->label('Mobile No')
                    ->default(null),
                TextInput::make('whatsapp_no')
                    ->default(null),
                Select::make('member_level')
                    ->label('Member Level')
                    ->required()
                    ->options([
                        'CO PILOT' => 'CO PILOT',
                        'PILOT' => 'PILOT',
                        'SECRETARY (M)' => 'SECRETARY (M)',
                        'SECRETARY (A)' => 'SECRETARY (A)',
                        'VICE PRESIDENT' => 'VICE PRESIDENT',
                        'PRESIDENT' => 'PRESIDENT',
                    ])
                ->searchable(),
                TextInput::make('primary_city')
                    ->default(null),
                TextInput::make('member_code')
                    ->default(null),
                TextInput::make('member_cadre')
                    ->default(null),
                TextInput::make('vg_group_code')
                    ->default(null),
                TextInput::make('vg_group_name')
                    ->default(null),
                TextInput::make('federation_code')
                    ->default(null),
                TextInput::make('federation_name')
                    ->default(null),
                TextInput::make('username')
                    ->required(),
                TextInput::make('password')
                    ->password()
                    ->required(),
            ])->columns(4);
    }
}
