<?php

namespace App\Filament\Resources\Settlements\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;
use Filament\Forms\Components\DatePicker;
use Filament\Tables\Columns\Column;

class SettlementForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                DatePicker::make('settlement_date')
                    ->label('Settlement Date')
                    ->required(),
                Select::make('settlement_mode')
                    ->label('Settlement Mode')
                    ->required()
                    ->options([
                        'cash' => 'Cash',
                        'bank_transfer' => 'Bank Transfer',
                        'other' => 'Other',
                    ]),
                TextInput::make('settlement_amount')
                    ->label('Settlement Amount')
                    ->numeric()
                    ->required(),
                Select::make('proof_type')
                    ->label('Proof Type')
                    ->required()
                    ->options([
                        'cheque' => 'Cheque',
                        'dd' => 'DD',
                        'written_statement' => 'Written Statement',
                        'affidavit' => 'Affidavit',
                    ]),
                FileUpload::make('image_upload')
                    ->label('Upload Proof')
                    ->image()
                    ->directory('settlement_proofs')
                    ->maxSize(500) // 2MB
                    ->acceptedFileTypes(['image/jpeg', 'image/jpg']) // ✅ browser filter
                    ->rules([
                        'mimes:jpg,jpeg',
                        'max:512', // 512 KB
                    ])
                    ->helperText('Only JPG/JPEG, max 500 KB'),
                Textarea::make('remarks')
                    ->required(),
            ])->Columns(3);
    }
}
