<?php

namespace App\Filament\Resources\Receipts\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use NumberFormatter;

class ReceiptsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('serial_no')
                    ->label('S.No')
                    ->alignCenter()
                    ->state(function ($rowLoop) {
                        return $rowLoop->iteration;
                    })
                    ->sortable(false)
                    ->searchable(false),
                TextColumn::make('customer_id')->label('Customer ID')->sortable()->searchable(),
                TextColumn::make('receipt_date')->label('Receipt Date')->date()->date('d-m-Y'),
                TextColumn::make('invested_amount')
                    ->label('Invested Amount')
                    ->alignRight()
                    ->formatStateUsing(function ($state) {
                        if ($state === null) return '-';
                        $formatter = new NumberFormatter('en_IN', NumberFormatter::DECIMAL);
                        return '₹ ' . $formatter->format($state);
                    }),
                TextColumn::make('company_name')->label('Company'),
                TextColumn::make('receipt_customer_name')->label('Customer Name'),
                TextColumn::make('relationship')->label('Relationship'),
                ImageColumn::make('receipt_image')->label('Receipt Image'),
                TextColumn::make('created_at')->label('Created At')->dateTime()->sortable(),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
