<?php

namespace App\Filament\Resources\Receipts\Pages;

use App\Filament\Resources\Receipts\ReceiptResource;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ListRecords;
use Filament\Notifications\Notification;

class ListReceipts extends ListRecords
{
    protected static string $resource = ReceiptResource::class;

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make()
                ->label('Add Receipt')
                ->icon('heroicon-m-plus-circle')
                ->after(function ($record, $livewire) {
                    // Use Filament notification and send it (works for modal)
                    Notification::make()
                        ->title('Successfully added.')
                        ->success()   // <- ensures success style
                        ->icon('heroicon-s-check') // optional
                        ->duration(3000)
                        ->send();
                }),
        ];
    }
}
