<?php

namespace App\Filament\Pages;

use BackedEnum;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;
use Filament\Facades\Filament;
use Illuminate\Support\Facades\Vite;

class UserProfile extends Page
{
    protected string $view = 'filament.pages.user-profile';

    protected static string|BackedEnum|null $navigationIcon = 'heroicon-m-user-circle';
    protected static string|null $navigationLabel = 'My Profile';
    protected static string|null $title = 'My Profile';
    protected static string|null $slug = 'profile'; // ✅ must be string
    protected static string|\UnitEnum|null $navigationGroup = 'Account';

    public $user;

    public function mount(): void
    {
        $this->user = Auth::user();
    }

    public static function shouldRegisterNavigation(): bool
    {
        return true;
    }

    protected function setUp(): void
    {
        parent::setUp();

        // Force Vite assets to load for this page
        Filament::registerRenderHook(
            'head.end',
            fn () => \Illuminate\Support\Facades\Vite::content([
                'resources/css/app.css',
                'resources/js/app.js',
            ])
        );
    }
}
