<?php

namespace App\Filament\Pages;

use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Pages\Page;
use Filament\Facades\Filament;
use App\Models\UserLogin;

class UserLoginLogs extends Page implements Tables\Contracts\HasTable
{
    use Tables\Concerns\InteractsWithTable;

    protected string $view = 'filament.pages.user-login-logs';

    protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-document-text';
    protected static ?string $navigationLabel = 'Login History';
    protected static string|\UnitEnum|null $navigationGroup = 'Account';

    protected function getTableQuery()
    {
        return UserLogin::where('user_id', Filament::auth()->id())
            ->latest()
            ->take(100);
    }

    public static function canView(): bool
    {
        return true; // visible for all users, including admin
    }

    protected function getTableColumns(): array
    {
        return [
            TextColumn::make('serial_no')
                ->label('S.No')
                ->alignCenter()
                ->state(function ($rowLoop) {
                    return $rowLoop->iteration;
                })
                ->sortable(false)
                ->searchable(false),
            TextColumn::make('ip_address')
                ->label('IP Address'),
            TextColumn::make('user_agent')
                ->limit(50)
                ->label('Device / Browser'),
            TextColumn::make('created_at')
                ->label('Login At')->dateTime(),
        ];
    }

    protected function getTableActions(): array
    {
        return [];
    }

    protected function getTableFilters(): array
    {
        return [];
    }

    public static function shouldRegisterNavigation(): bool
    {
        return true;
    }
}
